/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.megacrit.cardcrawl.core.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShaderHelper {
    private static final Logger logger = LogManager.getLogger(ShaderHelper.class.getName());
    private static ShaderProgram gsShader;
    private static ShaderProgram rsShader;
    private static ShaderProgram wsShader;
    private static ShaderProgram blurShader;
    private static ShaderProgram waterShader;
    private static ShaderProgram outlineShader;

    public static void initializeShaders() {
        ShaderProgram.pedantic = false;
        gsShader = new ShaderProgram(Gdx.files.internal("shaders/grayscale/vertexShader.vs").readString(), Gdx.files.internal("shaders/grayscale/fragShader.fs").readString());
        wsShader = new ShaderProgram(Gdx.files.internal("shaders/whiteSilhouette/vertexShader.vs").readString(), Gdx.files.internal("shaders/whiteSilhouette/fragShader.fs").readString());
        rsShader = new ShaderProgram(Gdx.files.internal("shaders/redSilhouette/vertexShader.vs").readString(), Gdx.files.internal("shaders/redSilhouette/fragShader.fs").readString());
        blurShader = new ShaderProgram(Gdx.files.internal("shaders/blur/vertexShader.vs").readString(), Gdx.files.internal("shaders/blur/fragShader.fs").readString());
        if (blurShader.getLog().length() != 0) {
            logger.info(blurShader.getLog());
        }
        blurShader.setUniformf("dir", 0.0f, 1.0f);
        blurShader.setUniformf("resolution", 1024.0f);
        blurShader.setUniformf("radius", 5.0f * Settings.scale);
        waterShader = new ShaderProgram(Gdx.files.internal("shaders/water/vertex.vs").readString(), Gdx.files.internal("shaders/water/fragment.fs").readString());
        outlineShader = new ShaderProgram(Gdx.files.internal("shaders/outline/vertex.vs").readString(), Gdx.files.internal("shaders/outline/fragment.fs").readString());
        outlineShader.begin();
        outlineShader.setUniformf("u_viewportInverse", new Vector2(0.0078125f, 0.0078125f));
        outlineShader.setUniformf("u_offset", 7.0f * Settings.scale);
        outlineShader.setUniformf("u_step", Math.min(1.0f, 128.0f));
        outlineShader.setUniformf("u_color", new Vector3(0.0f, 0.12f, 0.12f));
        outlineShader.end();
    }

    public static void setShader(SpriteBatch sb, Shader shader) {
        switch (shader) {
            case BLUR: {
                sb.end();
                sb.setShader(blurShader);
                sb.begin();
                break;
            }
            case DEFAULT: {
                sb.end();
                sb.setShader(null);
                sb.begin();
                break;
            }
            case GRAYSCALE: {
                sb.end();
                sb.setShader(gsShader);
                sb.begin();
                break;
            }
            case OUTLINE: {
                sb.end();
                sb.setShader(outlineShader);
                sb.begin();
                break;
            }
            case RED_SILHOUETTE: {
                sb.end();
                sb.setShader(rsShader);
                sb.begin();
                break;
            }
            case WATER: {
                sb.end();
                sb.setShader(waterShader);
                sb.begin();
                break;
            }
            case WHITE_SILHOUETTE: {
                sb.end();
                sb.setShader(wsShader);
                sb.begin();
                break;
            }
            default: {
                sb.end();
                sb.setShader(null);
                sb.begin();
            }
        }
    }

    public static void setShader(PolygonSpriteBatch sb, Shader shader) {
        switch (shader) {
            case BLUR: {
                sb.setShader(blurShader);
                break;
            }
            case DEFAULT: {
                sb.setShader(null);
                break;
            }
            case GRAYSCALE: {
                sb.setShader(gsShader);
                break;
            }
            default: {
                sb.setShader(null);
            }
        }
    }

    public static enum Shader {
        BLUR,
        DEFAULT,
        GRAYSCALE,
        RED_SILHOUETTE,
        WHITE_SILHOUETTE,
        OUTLINE,
        WATER;

    }
}

